%
%-------------------------------------------------------------
%
%	ROBOTRAN - Version 6.6 (build : february 22, 2008)
%
%	Copyright 
%	Universit catholique de Louvain 
%	Dpartement de Mcanique 
%	Unit de Production Mcanique et Machines 
%	2, Place du Levant 
%	1348 Louvain-la-Neuve 
%	http://www.robotran.be// 
%
%	==> Generation Date : Tue Oct 14 13:53:55 2008
%
%	==> Project name : five_point_suspension_matlab
%	==> using XML input file 
%
%	==> Number of joints : 17
%
%	==> Function : F 7 : Point to point Link Forces (frc,trq,Flnk) 
%	==> Flops complexity : 64
%
%	==> Generation Time :  0.000 seconds
%	==> Post-Processing :  0.000 seconds
%
%-------------------------------------------------------------
%
function [frc,trq,Flnk,Z,Zd] = link(s,tsim,usrfun)

 frc = zeros(3,17);
 trq = zeros(3,17);
 Flnk = zeros(1,1);
 Z = zeros(1,1);
 Zd = zeros(1,1);

q = s.q; 
qd = s.qd; 
qdd = s.qdd; 
frc = s.frc; 
trq = s.trq; 

% === begin imp_aux === 

% === end imp_aux === 

% ===== BEGIN task 0 ===== 

% = = Block_0_0_0_0_0_6 = = 
 
% Trigonometric Variables  

C11 = cos(q(11));
S11 = sin(q(11));
C12 = cos(q(12));
S12 = sin(q(12));

% = = Block_0_1_0_0_1_6 = = 
 
% Link Kinematics: Distance Z , Relative Velocity ZD 

ROlnk1_512 = C11*C12;
ROlnk1_612 = S11*C12;
RLlnk1_127 = -s.dpt(2,14)*S12;
RLlnk1_227 = ROlnk1_512*s.dpt(2,14);
RLlnk1_327 = ROlnk1_612*s.dpt(2,14);

% = = Block_0_1_0_1_1_6 = = 
 
% Link Kinematics: Distance Z , Relative Velocity ZD 

Plnk11 = RLlnk1_127+s.dpt(1,6)-s.dpt(1,7);
Plnk21 = RLlnk1_227+s.dpt(2,6)-s.dpt(2,7);
Plnk31 = RLlnk1_327+s.dpt(3,6)-s.dpt(3,7);
Z1 = sqrt(Plnk11*Plnk11+Plnk21*Plnk21+Plnk31*Plnk31);
e11 = Plnk11/Z1;
e21 = Plnk21/Z1;
e31 = Plnk31/Z1;
Zd1 = -(qd(12)*e11*s.dpt(2,14)*C12+e21*(qd(11)*RLlnk1_327-qd(12)*RLlnk1_127*C11)-e31*(qd(11)*RLlnk1_227+qd(12)*RLlnk1_127*S11));
 
% Link Force Computation 

Flink1 = usrfun.flink(Z1,Zd1,s,tsim,1);

% = = Block_0_1_0_2_2_1 = = 
 
% Link Dynamics : Forces projection on body-fixed frames 

fPlnk11 = Flink1*e11;
fPlnk21 = Flink1*e21;
fPlnk31 = Flink1*e31;
frc(1,1) = s.frc(1,1)+fPlnk11;
frc(2,1) = s.frc(2,1)+fPlnk21;
frc(3,1) = s.frc(3,1)+fPlnk31;
trq(1,1) = s.trq(1,1)-fPlnk21*s.dpt(3,7)+fPlnk31*s.dpt(2,7);
trq(2,1) = s.trq(2,1)+fPlnk11*s.dpt(3,7)-fPlnk31*s.dpt(1,7);
trq(3,1) = s.trq(3,1)-fPlnk11*s.dpt(2,7)+fPlnk21*s.dpt(1,7);

% = = Block_0_1_0_2_2_6 = = 
 
% Link Dynamics : Forces projection on body-fixed frames 

fSlnk11 = Flink1*(e11*C12+e21*C11*S12+e31*S11*S12);
fSlnk21 = Flink1*(ROlnk1_512*e21+ROlnk1_612*e31-e11*S12);
fSlnk31 = -Flink1*(e21*S11-e31*C11);
frc(1,12) = s.frc(1,12)-fSlnk11;
frc(2,12) = s.frc(2,12)-fSlnk21;
frc(3,12) = s.frc(3,12)-fSlnk31;
trq(1,12) = s.trq(1,12)-fSlnk31*(s.dpt(2,14)-s.l(2,12));
trq(3,12) = s.trq(3,12)+fSlnk11*(s.dpt(2,14)-s.l(2,12));

% = = Block_0_2_0_0_0_0 = = 
 
% Symbolic Outputs  

frc(1,3) = s.frc(1,3);
frc(2,3) = s.frc(2,3);
frc(3,3) = s.frc(3,3);
frc(1,5) = s.frc(1,5);
frc(2,5) = s.frc(2,5);
frc(3,5) = s.frc(3,5);
frc(1,6) = s.frc(1,6);
frc(2,6) = s.frc(2,6);
frc(3,6) = s.frc(3,6);
frc(1,8) = s.frc(1,8);
frc(2,8) = s.frc(2,8);
frc(3,8) = s.frc(3,8);
frc(1,10) = s.frc(1,10);
frc(2,10) = s.frc(2,10);
frc(3,10) = s.frc(3,10);
frc(1,15) = s.frc(1,15);
frc(2,15) = s.frc(2,15);
frc(3,15) = s.frc(3,15);
frc(1,16) = s.frc(1,16);
frc(2,16) = s.frc(2,16);
frc(3,16) = s.frc(3,16);
frc(1,17) = s.frc(1,17);
frc(2,17) = s.frc(2,17);
frc(3,17) = s.frc(3,17);
trq(1,3) = s.trq(1,3);
trq(2,3) = s.trq(2,3);
trq(3,3) = s.trq(3,3);
trq(1,5) = s.trq(1,5);
trq(2,5) = s.trq(2,5);
trq(3,5) = s.trq(3,5);
trq(1,6) = s.trq(1,6);
trq(2,6) = s.trq(2,6);
trq(3,6) = s.trq(3,6);
trq(1,8) = s.trq(1,8);
trq(2,8) = s.trq(2,8);
trq(3,8) = s.trq(3,8);
trq(1,10) = s.trq(1,10);
trq(2,10) = s.trq(2,10);
trq(3,10) = s.trq(3,10);
trq(2,12) = s.trq(2,12);
trq(1,15) = s.trq(1,15);
trq(2,15) = s.trq(2,15);
trq(3,15) = s.trq(3,15);
trq(1,16) = s.trq(1,16);
trq(2,16) = s.trq(2,16);
trq(3,16) = s.trq(3,16);
trq(1,17) = s.trq(1,17);
trq(2,17) = s.trq(2,17);
trq(3,17) = s.trq(3,17);
Flnk(1) = Flink1;
Z(1) = Z1;
Zd(1) = Zd1;

% ====== END Task 0 ====== 

  

